// SCTSE.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include "windows.h"
#include "stdio.h"
#include "conio.h"
#include "stdlib.h"
#include "SCTSEDll.h"

int main(int argc, char* argv[])
{
	CSCTSEDll   pcieAdp;
	int dll_major, dll_minor;
	int status = 0;
	int adpaddr = 0; 
    int board_index = 3; 
	int verbose = 0;
	int v_mcardv = 0;
	double current,volt;
	double  vbatvolt, oclimit;
	unsigned long snno = 0;
	char ch;

	if (argc > 1)
	{
		board_index = atoi(argv[1]);
	} 
	if (argc > 2) verbose = 1;
    
	// SCTS-E (S1) DIP Switch Address Setting (Default : 3) 
    adpaddr = 3;	

	status = pcieAdp.SCTSECTL_OPEN(adpaddr);	
	if (status != 0)
	{
		printf("No SCTS-E Card Found On System !\n\n");
		printf("Please Contact Soliton Tech. Co, LTD.\n");
		printf("http://www.soliton.com.tw\n\n");
		system("pause");
		return 1;
	} 
	else
	{
		printf("SCTS-E Address[%d]\n", adpaddr);
		printf("SCTS-E Card Found On System .\n");
	}
    status =pcieAdp.SCTSECTL_CHECKSDCD();
	if(status == 0)
	{
		printf("No SD/SDIO device on system .\n\n");
	}
	else if(status == 1) 
	{
		printf("Detected SD/SDIO device plugin ... \n\n");
	}
	else printf("CHECKSDCD Status : %d .\n\n",status);
	Sleep(100);
	
	do
	{
		printf("[Press Command]\n");
		printf("1 : Power on\n");
		printf("2 : Power off\n");
		printf("3 : LED Go\n");
		printf("4 : LED NG\n");
		printf("5 : LED Off\n");
		printf("6 : Get Normal Power V-I\n");
		printf("7 : Get VBAT   Power V-I\n");
		printf("8 : GPIO-0 On\n");
		printf("9 : GPIO-0 Off\n");
		printf("a : Beep 1\n");
		printf("b : Beep 2\n");
        printf("c : Get SCTS-E INFO \n");
		printf("q : Quit\n\n");
		status = 0;
		ch = getch();
		system("cls");
		switch(ch)
		{
		case '1' :	
			status = pcieAdp.SCTSCTL_PON();
			printf("[SCTS-E Power On] Status = %d\n", status);
            
			status = pcieAdp.SCTSECTL_MCARD_CHECKOC();
			printf("[Over Current] Status = %d\n\n", status);
			break;
		case '2':
			status = pcieAdp.SCTSCTL_POFF();
			printf("[SCTS-E Power Off] Status = %d\n\n", status);
			break;
		case '3':
			status = pcieAdp.SCTSECTL_LEDGO();
			break;
		case '4':
			status = pcieAdp.SCTSECTL_LEDNG();
			break;
		case '5':
			status = pcieAdp.SCTSECTL_LEDOFF();
			break;
		case '6':
			status = pcieAdp.SCTSECTL_MEAS_MV_VOLTAGE(&volt);
			Sleep(50);
			status = pcieAdp.SCTSECTL_MEAS_MV_CURRENT(&current);
			printf("[Normal Power] V= %.2f(V)  I= %.3f(mA)\n\n", volt, current*1e3);
			break;
        case '7':
			status = pcieAdp.SCTSECTL_MEAS_VBAT_VOLTAGE(&volt);
			Sleep(50);
			status = pcieAdp.SCTSECTL_MEAS_VBAT_CURRENT(&current);
			printf("[VBAT Power] V= %.2f(V)  I= %.3f(mA)\n\n", volt, current*1e3);
			break;
		case '8':
			//[GPIO]  0: DUTCTL0   1:DUTCTL1  
		    //Set DUTCTL0 Output (H) 	
			status = pcieAdp.SCTSECTL_GPIOSET(0);             
			break;
		case '9':
			//[GPIO]  0:DUTCTL0   1:DUTCTL1	
			//Set DUTCTL0 Output (L)  	
			status = pcieAdp.SCTSECTL_GPIORESET(0);
			break;
		case 'a':
			status = pcieAdp.SCTSECTL_BEEP(0, 1000);
			break;
		case 'b':
			status = pcieAdp.SCTSECTL_BEEP(3, 500);
			break;

	    case 'c':
            pcieAdp.GETLIBVER(&dll_major, &dll_minor);
		    printf("SCTSE DLL Version : V %d.%d \n", dll_major, dll_minor);

			status = pcieAdp.SCTSECTL_GET_SN(&snno);
			printf("Serial Number : %X\n", snno);

	        status = pcieAdp.SCTSECTL_GET_VBAT(&vbatvolt);
	        printf("VBAT Voltage : %.2lf (V)\n", vbatvolt);

			status = pcieAdp.SCTSECTL_GET_VBAT_OC(&oclimit);
			printf("VBAT OC : %.1lf (A)\n", oclimit);

			status = pcieAdp.SCTSECTL_GET_MV_OC(&oclimit);
			printf("Normal OC : %.1lf (A)\n", oclimit);

			status = pcieAdp.SCTSECTL_GET_OC_RAIL(&v_mcardv);
			if (v_mcardv == SCTSECTL_OCRAIL_MV) {
				printf("OC Control Mode : Normal\n\n");
			}
			else if (v_mcardv == SCTSECTL_OCRAIL_VBAT){
				printf("OC Control Mode : VBAT\n\n");
			}
			break;
	
		default:
			break;
		}
		//printf("Status = %d\n", status);
	}while(ch != 'q');

	pcieAdp.SCTSCTL_PON();
	pcieAdp.SCTSECTL_CLOSE();
	return 0;
}

